
# Transient Acceleration App Note Example

import FXOS8700CQ
import aardvark_setup
from aardvark_py import *
import time
import math
from config import *

# Print Revision

print "AN4461 SW Rev: " + str(REVISION)

# Setup Aardvark

(handle, INT1_PIN) = aardvark_setup.setup_aardvark()

# Update aardvark handle in FXOS8700CQ.py

FXOS8700CQ.handle = handle

# Reset 

FXOS8700CQ.reset_FXOS8700CQ()

# TRANSIENT_THS:  63mg x 5 = 315mg, debounce behavior:
# clear when condition not true

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x1F, 0x85] )  # write a byte 0x85 to address 0x1F

# TRANSIENT_COUNT = 80ms (based on ODR and hybrid mode, see Table 68 in datasheet)

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x20, 0x02] )

# A_TRAN_INIT_MSB... initial reference set to 0g for all axes

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x79, 0x00] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x7A, 0x00] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x7B, 0x00] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x7C, 0x00] )

# TRANSIENT_CFG: 
# tran_qs_ele = 1 => event latching enabled
# tran_qs_zefe = 0 => do not detect events on z-axis
# tran_qs_yefe = 1 => y-axis event detection enabled
# tran_qs_xefe = 1 => x-axis event detection enabled
# tran_qs_hpf_byp = 0 => high-pass filter is NOT bypassed

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x1D, 0b00010110] )	

# enable interrupts for the feature

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2D, 0x20] )

# route interrupts to INT1 pin

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2E, 0x20] )

# Setup device for hybrid mode, enable hybrid mode auto-increment, 
# ODR = 6.25Hz, OSR=256, go to ACTIVE mode using M_CTRL_REG1, M_CTRL_REG2 and
# CTRL_REG1

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5B, 0x1F] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5C, 0x20] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2A, 0x29] )    

# Wait for INT1 to assert and clear interrupt by reading register TRANSIENT_SRC (0x1E)

while( True ):
    transition = aa_gpio_change( handle, 100 )
    if (transition & INT1_PIN ) == INT1_PIN:
        print "No interrupt..."
        continue
    (count, dataIn) = FXOS8700CQ.read_FXOS8700CQ( 0x1E, 1 )
    print "TRAN_SRC = 0x%X" % dataIn[0]
    if( (dataIn[0] & 0x40) == 0x40 ):
        print "Event detected!!!"
